using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class CustomerCreditCardsBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            //
            //CustomerCreditCardsBO
            //'
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[cc_pk],[cc_cust_pk],[cc_NameOnCard],[cc_CardNumber],[cc_Expiration],[cc_VerificationCode],[cc_Created],[cc_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "cc_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "CustomerCreditCards";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("cc_pk", typeof(System.Int32)),
new DataColumn("cc_cust_pk", typeof(System.Int32)),
new DataColumn("cc_NameOnCard", typeof(System.String)),
new DataColumn("cc_CardNumber", typeof(System.String)),
new DataColumn("cc_Expiration", typeof(System.DateTime)),
new DataColumn("cc_VerificationCode", typeof(System.String)),
new DataColumn("cc_Created", typeof(System.DateTime)),
new DataColumn("cc_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(CustomerCreditCardsBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(CustomerCreditCardsBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 cc_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["cc_pk"];
            }
            set
            {
                this.CurrentRow["cc_pk"] = value;
            }
        }

        /// <summary>
        /// Foreign Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Foreign Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 cc_cust_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["cc_cust_pk"];
            }
            set
            {
                this.CurrentRow["cc_cust_pk"] = value;
            }
        }

        /// <summary>
        /// Name On Card
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Name On Card"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cc_NameOnCard
        {
            get
            {
                return (System.String)this.CurrentRow["cc_NameOnCard"];
            }
            set
            {
                this.CurrentRow["cc_NameOnCard"] = value;
            }
        }

        /// <summary>
        /// Credit Card Number
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Credit Card Number"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cc_CardNumber
        {
            get
            {
                return (System.String)this.CurrentRow["cc_CardNumber"];
            }
            set
            {
                this.CurrentRow["cc_CardNumber"] = value;
            }
        }

        /// <summary>
        /// Expiration Date
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Expiration Date"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime cc_Expiration
        {
            get
            {
                return (System.DateTime)this.CurrentRow["cc_Expiration"];
            }
            set
            {
                this.CurrentRow["cc_Expiration"] = value;
            }
        }

        /// <summary>
        /// Security Verification Code
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Security Verification Code"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.String cc_VerificationCode
        {
            get
            {
                return (System.String)this.CurrentRow["cc_VerificationCode"];
            }
            set
            {
                this.CurrentRow["cc_VerificationCode"] = value;
            }
        }

        /// <summary>
        /// Time Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Time Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime cc_Created
        {
            get
            {
                return (System.DateTime)this.CurrentRow["cc_Created"];
            }
            set
            {
                this.CurrentRow["cc_Created"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 cc_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["cc_Version"];
            }
            set
            {
                this.CurrentRow["cc_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum CustomerCreditCardsBOFieldNames
        {
            cc_pk,
            cc_cust_pk,
            cc_NameOnCard,
            cc_CardNumber,
            cc_Expiration,
            cc_VerificationCode,
            cc_Created,
            cc_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(CustomerCreditCardsBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<CustomerCreditCardsBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<CustomerCreditCardsBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<CustomerCreditCardsBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the CustomerCreditCardsBO class.
        /// </summary>
        static CustomerCreditCardsBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(13);
            _PropertyDescriptors.Add("cc_pk", new FieldDescriptor(CustomerCreditCardsBOFieldNames.cc_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("cc_cust_pk", new FieldDescriptor(CustomerCreditCardsBOFieldNames.cc_cust_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("cc_NameOnCard", new FieldDescriptor(CustomerCreditCardsBOFieldNames.cc_NameOnCard, typeof(System.String)));
            _PropertyDescriptors.Add("cc_CardNumber", new FieldDescriptor(CustomerCreditCardsBOFieldNames.cc_CardNumber, typeof(System.String)));
            _PropertyDescriptors.Add("cc_Expiration", new FieldDescriptor(CustomerCreditCardsBOFieldNames.cc_Expiration, typeof(System.DateTime)));
            _PropertyDescriptors.Add("cc_VerificationCode", new FieldDescriptor(CustomerCreditCardsBOFieldNames.cc_VerificationCode, typeof(System.String)));
            _PropertyDescriptors.Add("cc_Created", new FieldDescriptor(CustomerCreditCardsBOFieldNames.cc_Created, typeof(System.DateTime)));
            _PropertyDescriptors.Add("cc_Version", new FieldDescriptor(CustomerCreditCardsBOFieldNames.cc_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(8);
            _AllFieldsList.Add("cc_pk");
            _AllFieldsList.Add("cc_cust_pk");
            _AllFieldsList.Add("cc_NameOnCard");
            _AllFieldsList.Add("cc_CardNumber");
            _AllFieldsList.Add("cc_Expiration");
            _AllFieldsList.Add("cc_VerificationCode");
            _AllFieldsList.Add("cc_Created");
            _AllFieldsList.Add("cc_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(8);
            _FieldDbTypes.Add("cc_pk", DbType.Int32);
            _FieldDbTypes.Add("cc_cust_pk", DbType.Int32);
            _FieldDbTypes.Add("cc_NameOnCard", DbType.AnsiString);
            _FieldDbTypes.Add("cc_CardNumber", DbType.String);
            _FieldDbTypes.Add("cc_Expiration", DbType.DateTime);
            _FieldDbTypes.Add("cc_VerificationCode", DbType.AnsiString);
            _FieldDbTypes.Add("cc_Created", DbType.DateTime);
            _FieldDbTypes.Add("cc_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(9);
            _FieldEnums.Add("cc_pk", CustomerCreditCardsBOFieldNames.cc_pk);
            _FieldEnums.Add("cc_cust_pk", CustomerCreditCardsBOFieldNames.cc_cust_pk);
            _FieldEnums.Add("cc_NameOnCard", CustomerCreditCardsBOFieldNames.cc_NameOnCard);
            _FieldEnums.Add("cc_CardNumber", CustomerCreditCardsBOFieldNames.cc_CardNumber);
            _FieldEnums.Add("cc_Expiration", CustomerCreditCardsBOFieldNames.cc_Expiration);
            _FieldEnums.Add("cc_VerificationCode", CustomerCreditCardsBOFieldNames.cc_VerificationCode);
            _FieldEnums.Add("cc_Created", CustomerCreditCardsBOFieldNames.cc_Created);
            _FieldEnums.Add("cc_Version", CustomerCreditCardsBOFieldNames.cc_Version);
            _FieldEnums.Add("CUSTOM_FIELD", CustomerCreditCardsBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(8);
            _FieldLengths.Add("cc_pk", 4);
            _FieldLengths.Add("cc_cust_pk", 4);
            _FieldLengths.Add("cc_NameOnCard", 50);
            _FieldLengths.Add("cc_CardNumber", -1);
            _FieldLengths.Add("cc_Expiration", 8);
            _FieldLengths.Add("cc_VerificationCode", 10);
            _FieldLengths.Add("cc_Created", 8);
            _FieldLengths.Add("cc_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(8);
            _FieldNativeDbTypes.Add("cc_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("cc_cust_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("cc_NameOnCard", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("cc_CardNumber", (int)System.Data.SqlDbType.NVarChar);
            _FieldNativeDbTypes.Add("cc_Expiration", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("cc_VerificationCode", (int)System.Data.SqlDbType.VarChar);
            _FieldNativeDbTypes.Add("cc_Created", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("cc_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(8);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the CustomerCreditCardsBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<CustomerCreditCardsBOFieldNames>
        {
            public FieldDescriptor(CustomerCreditCardsBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(CustomerCreditCardsBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case CustomerCreditCardsBOFieldNames.cc_pk:
                        return ((CustomerCreditCardsBO)component).cc_pk;
                    case CustomerCreditCardsBOFieldNames.cc_cust_pk:
                        return ((CustomerCreditCardsBO)component).cc_cust_pk;
                    case CustomerCreditCardsBOFieldNames.cc_NameOnCard:
                        return ((CustomerCreditCardsBO)component).cc_NameOnCard;
                    case CustomerCreditCardsBOFieldNames.cc_CardNumber:
                        return ((CustomerCreditCardsBO)component).cc_CardNumber;
                    case CustomerCreditCardsBOFieldNames.cc_Expiration:
                        return ((CustomerCreditCardsBO)component).cc_Expiration;
                    case CustomerCreditCardsBOFieldNames.cc_VerificationCode:
                        return ((CustomerCreditCardsBO)component).cc_VerificationCode;
                    case CustomerCreditCardsBOFieldNames.cc_Created:
                        return ((CustomerCreditCardsBO)component).cc_Created;
                    case CustomerCreditCardsBOFieldNames.cc_Version:
                        return ((CustomerCreditCardsBO)component).cc_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case CustomerCreditCardsBOFieldNames.cc_pk:
                        ((CustomerCreditCardsBO)component).cc_pk = (System.Int32)value;
                        break;
                    case CustomerCreditCardsBOFieldNames.cc_cust_pk:
                        ((CustomerCreditCardsBO)component).cc_cust_pk = (System.Int32)value;
                        break;
                    case CustomerCreditCardsBOFieldNames.cc_NameOnCard:
                        ((CustomerCreditCardsBO)component).cc_NameOnCard = (System.String)value;
                        break;
                    case CustomerCreditCardsBOFieldNames.cc_CardNumber:
                        ((CustomerCreditCardsBO)component).cc_CardNumber = (System.String)value;
                        break;
                    case CustomerCreditCardsBOFieldNames.cc_Expiration:
                        ((CustomerCreditCardsBO)component).cc_Expiration = (System.DateTime)value;
                        break;
                    case CustomerCreditCardsBOFieldNames.cc_VerificationCode:
                        ((CustomerCreditCardsBO)component).cc_VerificationCode = (System.String)value;
                        break;
                    case CustomerCreditCardsBOFieldNames.cc_Created:
                        ((CustomerCreditCardsBO)component).cc_Created = (System.DateTime)value;
                        break;
                    case CustomerCreditCardsBOFieldNames.cc_Version:
                        ((CustomerCreditCardsBO)component).cc_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
